# include <stdio.h>
# include <stdlib.h>
# include <limits.h>
# include <string.h>

# define TT(a,b) (table[a][(b-1)/8])&(0x01<<((b-1)%8)) 
/* value of b-th letter in a-th atom(true or false) */

void read_param( void );
void set_param( void );
void interpretation( void );
void formula( void );
void summand( void );  /* falila ; */
void disjunct( void );
void end( void );

unsigned char boolrand( void );
unsigned int intrand(unsigned int);
unsigned long int longrand(unsigned long int);
double doubrand();
double doubrand1( double );
void initrand( unsigned int );
void gr( int );
unsigned int ucc( FILE* );
unsigned long int ucc1( FILE* );


FILE *f,*g;
unsigned char **table,*z,*u,*r,*v;
double s,k0,k1,*w;
unsigned int len,l,M,n,Seed;
unsigned long D;


main(int argc, char *argv[])
{
    unsigned int i;
    
    if (argc!=2) gr(1);
    if ( ( f = fopen(argv[1],"r") ) == NULL) gr(2); /*l,M,n,D*/
    read_param();
    
    fprintf(g,"%d %d\tNumber of formulae and letters\n",l,n);
                 
    set_param();
     
    for(i=0;i<l;i++) formula();
                             
    interpretation();
    end();
    return;
       
} /* main----------------------------------------------------------- */

void read_param()
{
    
    unsigned int i;
    unsigned char cc, o[512];
    
    Seed=ucc(f);
    l=ucc(f);
    M=ucc(f);
    n=ucc(f);
    D=ucc1(f);
    
    i=0;
    while ( ((cc=fgetc(f)) != '\n') && !feof(f) ) o[i++]=cc;
    o[i]='\0';
    if ((g=fopen(o,"w"))==NULL) gr(3); /*output file*/
    fclose(f);
} /*read_param-------------------------------------------------------------- */
                          
void set_param()
{                   
    unsigned int i,q,j,e;
    float s;
    if ( Seed != 0 ) initrand( Seed ); 
    
    s=1; /*suma of interpretation*/
    
    len=n/8;
    if (n%8) len++; /*byte-lenth of a atom */
    
    if ((w=calloc(l,sizeof(double)))==NULL) 
    gr(4);/*intended interpretation*/
    
    if ((z=calloc(l,sizeof(unsigned char)))==NULL) 
    gr(5);/*atoms satisfied by formula*/
    
    if ((u=calloc(l,sizeof(unsigned char)))==NULL) 
    gr(6);/*atoms satisfied by disjunct*/
    
    if ((r=calloc(n+1,sizeof(unsigned char)))==NULL) 
    gr(7);/*letters that consists formula*/
    
    if ((table=calloc(l,sizeof(unsigned char*)))==NULL) 
    gr(8);/*atoms of not-nil measure*/
    
    for(i=0;i<l;i++) /*setting of atoms and probablities*/
    {  
      w[i] = doubrand1( s );
      s-=w[i];
      if ((table[i]=calloc(len,sizeof(unsigned char)))==NULL) gr(9); 
      do
      {
         for(j=0;j<len;j++) table[i][j]=intrand(256);
         /*choosing of i-th atom*/
         
         if (i==0) e=0;
              else for(q=0;q<i;q++) 
                   {
                      e=1;
                      /* are i-th and q-th atom different*/ 
                      for(j=0;j<len && e;j++) e/*&&*/=(table[i][j]==table[q][j]);
                      /*if they are equal, break*/
                      if (e) break;   
                    }
        
      }while(e); /*while there is equal atoms*/ 
    } /* for( i= */
    w[0]+=s;
}/*set_param-----------------------------------------------------------*/

void formula()
{
   float b;/*right side*/
   unsigned int m,i;
   char cc;
   
   s=k0=k1=0;
   m=intrand(M);/*number of summands*/
   fprintf(g,"%d\tNumber of summands\n",m);
   s=0;/*sum of left side*/
    
   for(i=0;i<m;i++) summand();
   
                         /*choosing of right side of formula*/             
   b=(doubrand1(k0+k1)<k0)?(-doubrand1(k0)):doubrand1(k1);
             
   /*cossing of relational symbol*/
   if (s>b) if (boolrand()) cc=']';
                                  else cc='>';
       else if (s<b) if (boolrand()) cc='[';
                                else cc='<';
                           else cc='=';
    fprintf(g,"%c %f\t Relational symbol and right side\n",cc,b);
             
}/*formula-------------------------------------------------------------*/

void  summand()
{ 
     float a/*coefficient*/;
     unsigned long d/*number of disjuncts*/;
     int t,q;
     
     /*choosing*/
     a=(boolrand()?1:-1)*doubrand();
     d=longrand(D);
     fprintf(g,"%f %lu\tCoefficient and number of disjuncts\n",a,d);
                     
     for(t=0;t<l;t++) z[t]=0;
      /*empty formula doesn't satisfy atoms*/
                     
     for(q=0;q<d;q++) disjunct();
             
             /*adding probablity of formula to sum*/
     for(t=0;t<l;t++) if (z[t]) s+=a*w[t];
     
     k0+=(a<0)?-a:0;
     k1+=(a<0)?0:a;
}/*summand--------------------------------------------------------------*/
 
void disjunct()
 {
   unsigned int c/*number of literals*/,x,p,e,t;
   
   c=intrand(n);
   fprintf(g,"%u",c);
                             
   for(x=1;x<=n;x++) r[x]=0;
   x=0;
   while (x<c) if (!r[e=intrand(n)])
                                   {
                                    r[e]=1;
                                    x++;
                                    }/*choosing of c letters*/
   
   for(t=0;t<l;t++) u[t]=1;                    
   /*all atoms are satisfied with empty disjunct*/
                             
                             
   for(p=1;p<=n;p++) if (r[p]){
                                e=boolrand();/*choosing of negation*/
                                fprintf(g," %d",e?p:-p);
                                      
                                for(t=0;t<l;t++)
                                     /*searching for atoms that satisfy disjunct*/
                                             u[t]=u[t]&&(TT(t,p)?e:!e);
                                }
                                
   for (t=0;t<l;t++) z[t]=z[t]||u[t];
                                /*atoms that satisfy formula */ 
                              
   fprintf(g,"\tNumber of literals and literals\n");
 }/*disjunct--------------------------------------------------------------*/      
             
void interpretation()
{
  int i,j;
  
  for (i=0;i<l;i++) for (j=0;j<len;j++) fprintf(g,"%d ",table[i][j]);
  fprintf(g,"\tSequence of atoms\n");
  
  for(i=0;i<l;i++) fprintf(g,"%f ",w[i]); 
  fprintf(g,"\tSequence of probabilities");
}/*interpretation---------------------------------------------------------*/

void end()
{
   int i;
   fclose(g);  
    
   for(i=0;i<l;i++) free(table[i]);
   free(table);
   free(w);
   free(z);
   free(u);
   free(r);
}/*end---------------------------------------------------------------------*/  
 
unsigned char boolrand()
{
    return ((unsigned int) rand()%2);
}
    
unsigned int intrand(unsigned int g)
{
   unsigned int b=rand();
   return (g>0)?(b%g+1):b;
}
   
unsigned long int longrand(unsigned long int g)
{
   unsigned long int b=intrand(0)*UINT_MAX+intrand(0);
   return (g>0)?(b%g+1):b;
}

double doubrand( )
{
   unsigned long int a,b;
   while (!(b=longrand(0)));
   a=longrand(0);
   return (a/(double)b);
}

double doubrand1( double g )
{
   return( g * rand() / (double) UINT_MAX );
}
   
void initrand(unsigned int Seed)
{
   srand( Seed );
}
     
void gr(int g)
{
  printf("Greska broj %d!!!\n",g);
  exit(1);
}
          
unsigned int ucc(FILE *f)
{
     unsigned int a;
     fscanf(f,"%u",&a);
     while (fgetc(f)!='\n') if (feof(f)) break;
     return a;
}
     
unsigned long int ucc1(FILE *f)
{
  unsigned long int a;
  fscanf(f,"%lu",&a);
  while (fgetc(f)!='\n') if (feof(f)) break;
  return a;
} 
  
               